﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Algorithms;
using DataProcessing;
using System.Threading;

namespace GUI
{
    public partial class Form1 : Form
    {
        Solver mySolver = new Solver();
        DataFile myData = new DataFile();
        Point[] points = new Point[4700];
        Point[] graphPoints = new Point[4700];
        
        Thread th;

        double[,] coord;
        double[,] data;
        string[] textCoordinates;

        

        public Form1()
        {
            InitializeComponent();
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.ShowDialog();

                eraseScreen();

                th = new Thread(thread1);
                if (th.IsAlive == true)
                {
                    th.Abort();
                }

                string fileName = dlg.FileName;
                textCoordinates = myData.ReadFile(fileName);
                label5.Text = myData.Dim;
                label8.Text = myData.Name;
                label6.Text = myData.Tour;

                coord = myData.PreProcessing(textCoordinates);

                //store coordinates for scaling
                for (int i = 0; i < coord.GetLength(0); i++)
                {
                    points[i].X = Convert.ToInt32(coord[i, 0]);
                    points[i].Y = Convert.ToInt32(coord[i, 1]);
                }


                //Scale coordinates
                for (int j = 0; j < coord.GetLength(0); j++)
                {
                    points[j].X = (((panel1.Width - 50) - 0) * (points[j].X - myData.LowX)) / (myData.HighX - myData.LowX) + 0;
                    points[j].Y = (((panel1.Height - 50) - 0) * (points[j].Y - myData.LowY)) / (myData.HighY - myData.LowY) + 0;
                }

                //Plot cities
                Graphics element = panel1.CreateGraphics();
                Brush brushes = (Brush)Brushes.Red;
                Pen pens = new Pen(brushes);
                Rectangle rectangle = new Rectangle();
                rectangle.Width = 1;
                rectangle.Height = 1;
                eraseScreen();

                for (int g = 0; g < coord.GetLength(0); g++)
                {
                    rectangle.X = points[g].X;
                    rectangle.Y = points[g].Y;
                    element.DrawRectangle(pens, rectangle);
                }

                for (int i = 0; i < points.Length; i++)
                {
                    points[i].X = 0;
                    points[i].Y = 0;
                }

                data = myData.Sort(coord);
            }
            catch
            {
                
            }
        }


        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            th = new Thread(thread1);
            if (th.IsAlive == true)
            {
                th.Abort();
            }

            Application.Exit();
        }

        private void greedyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Multi-threading
            th = new Thread(thread1);
            th.Start();
        }

        public void thread1()
        {
            try
            {
                int[] graphPointX = new int[coord.GetLength(0) + 1];
                int[] graphPointY = new int[coord.GetLength(0) + 1];

                mySolver.Greedy(data, coord); //run Greedy

                label7.Invoke((Action)delegate
                {
                    label7.Text = mySolver.Formatted;
                });

                //Grab coordinates of the shortest path
                for (int i = 0; i < mySolver.ShortestPath.Length; i++)
                {
                    graphPointX[i] = Convert.ToInt32(mySolver.CityX[mySolver.ShortestPath[i]]);
                    graphPointY[i] = Convert.ToInt32(mySolver.CityY[mySolver.ShortestPath[i]]);
                }

                //Store them in a new array
                for (int i = 0; i < mySolver.ShortestPath.Length; i++)
                {
                    graphPoints[i].X = graphPointX[i];
                    graphPoints[i].Y = graphPointY[i];
                }

                //Scale coordinates
                for (int j = 0; j <= coord.GetLength(0); j++)
                {
                    graphPoints[j].X = (((panel1.Width - 50) - 0) * (graphPoints[j].X - myData.LowX)) / (myData.HighX - myData.LowX) + 0;
                    graphPoints[j].Y = (((panel1.Height - 50) - 0) * (graphPoints[j].Y - myData.LowY)) / (myData.HighY - myData.LowY) + 0;
                }

                //Plot tour
                Graphics element2 = panel1.CreateGraphics();
                Brush brushes2 = (Brush)Brushes.Blue;
                Pen pens2 = new Pen(brushes2);

                for (int i = 0; i < graphPointX.Length - 1; i++)
                {
                    element2.DrawLine(pens2, graphPoints[i], graphPoints[i + 1]);
                }

                MessageBox.Show("Greedy completed!");
            }

            catch
            {
                MessageBox.Show("Please select a map before running an algorithm!");
            }
            
            
        }




        private void label5_Click(object sender, EventArgs e)
        {

        }

        private void label8_Click(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            eraseScreen();
        }
        private void eraseScreen()
        {
            Graphics eraser = panel1.CreateGraphics();
            eraser.Clear(panel1.BackColor);
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {

        }

        
    }
}
