﻿using System;
using System.IO;
using System.Linq;


namespace DataProcessing
{
    public class DataFile
    {
        private string dim;
        private string name;
        private string tour;
        
        private int lowX, highX, lowY, highY;

        public int LowX
        {
            get
            {
                return lowX;
            }

            set
            {
                lowX = value;
            }
        }

        public int LowY
        {
            get
            {
                return lowY;
            }

            set
            {
                lowY = value;
            }
        }

        public int HighX
        {
            get
            {
                return highX;
            }

            set
            {
                highX = value;
            }
        }

        public int HighY
        {
            get
            {
                return highY;
            }

            set
            {
                highY = value;
            }
        }
        public string Dim
        {
            get
            {
                return dim;
            }

            set
            {
                dim = value;
            }
        }

        public string Name
        {
            get
            {
                return name;
            }

            set
            {
                name = value;
            }
        }

        public string Tour
        {
            get
            {
                return tour;
            }

            set
            {
                tour = value;
            }
        }

        public string[] ReadFile(string input)
        {
            string text = File.ReadAllText(input);
            string[] textCoordinates;

            //Get the desired data

            //Number of cities
            int startPos = text.LastIndexOf("DIMENSION : ") + "DIMENSON : ".Length + 1;
            int length = text.IndexOf("EDGE_WEIGHT_TYPE") - startPos;
            Dim = text.Substring(startPos, length);

            //Name
            startPos = text.LastIndexOf("NAME :") + "NAME :".Length + 1;
            length = text.IndexOf("COMMENT") - startPos;
            Name = text.Substring(startPos, length);

            //Optimum tour length
            startPos = text.LastIndexOf("Optimum tour length is") + "Optimum tour length is".Length + 1;
            length = text.IndexOf("TYPE") - startPos;
            Tour = text.Substring(startPos, length);

            //Store the coordinates in an array
            startPos = text.LastIndexOf("NODE_COORD_SECTION") + "NODE_COORD_SECTION".Length + 1;
            length = text.IndexOf("EOF") - startPos;
            string nodes = text.Substring(startPos, length - 1);

            //Separate array into the various lines of the text 
            textCoordinates = nodes.Split(new string[] { Environment.NewLine }, StringSplitOptions.None);

            return textCoordinates;
        }
        public double[,] PreProcessing(string[] textCoordinates)
        {
            double x1 = 0;
            double x2 = 0;
            string[] temp;
            double[,] coord = new double[textCoordinates.Length, 2];
            int[] pointsX = new int[textCoordinates.Length];
            int[] pointsY = new int[textCoordinates.Length];


            //Keep only the X and Y coordinates
            for (int i = 0; i < textCoordinates.Length; i++)
            {
                temp = textCoordinates[i].Split(' ');
                x1 = Convert.ToDouble(temp[1]);
                x2 = Convert.ToDouble(temp[2]);
                coord[i, 0] = x1;
                coord[i, 1] = x2;
                pointsX[i] = Convert.ToInt32(x1);
                pointsY[i] = Convert.ToInt32(x2);
            }

            //Look for the highest and lowest values in each array for scaling purposes
            LowX = pointsX.Min();
            LowY = pointsY.Min();
            HighX = pointsX.Max();
            HighY = pointsY.Max();
                        
            return coord;


        }//end method PreProcessing

        public double[,] Sort(double[,] coord)
        {
            double insert;

            //Calculate distance from city A to city B
            double hip = 0;
            double[,] order = new double[coord.GetLength(0), coord.GetLength(0)];
            for (int x = 0; x < coord.GetLength(0); x++)
            {
                
                for (int y = 0; y < coord.GetLength(0); y++)
                {
                    hip = Math.Sqrt(Math.Pow((coord[x, 0] - coord[y, 0]), 2) + Math.Pow((coord[x, 1] - coord[y, 1]), 2));
                    order[x, y] = hip;
                    
                }//end inner for
            }//end outer for

            //Insertion method of sorting
            for (int row = 0; row < order.GetLength(0); row++)
            {
                for (int next = 1; next < order.GetLength(1); next++)
                {
                    insert = order[row, next];

                    int moveItem = next;

                    while (moveItem > 0 && order[row, (moveItem - 1)] > insert)
                    {
                        order[row, moveItem] = order[row, (moveItem - 1)];
                        moveItem--;
                    }//end while

                    order[row, moveItem] = insert;
                }//end inner for
            }//end outer for
            return order;
        }//end Method Sort
    }
}
