﻿//Solver class for the TSP, includes methods for various algorithms to solve the problem
using System;


namespace Algorithms
{
    public class Solver
    {
        private int[] shortestPath;
        private double[] cityX;
        private double[] cityY;
        private string formatted;

        public double[] CityX
        {
            get
            {
                return cityX;
            }

            set
            {
                cityX = value;
            }
        }

        public double[] CityY
        {
            get
            {
                return cityY;
            }

            set
            {
                cityY = value;
            }
        }
        public int[] ShortestPath
        {
            get
            {
                return shortestPath;
            }

            set
            {
                shortestPath = value;
            }
        }

        public string Formatted
        {
            get
            {
                return formatted;
            }

            set
            {
                formatted = value;
            }
        }

        public void Greedy(double[,] data, double[,] coord)
        {
            int cnt = 0;  //counter
            int sCity = 0; //starting city
            int currentCity = 0;
            int x = 0;
            int a = 0;
            int[] currentPath = new int[data.GetLength(0)+1];
            ShortestPath = new int[data.GetLength(0)+1];
            CityX = new double[coord.GetLength(0)];
            CityY = new double[coord.GetLength(0)];
            int k = 0;

            int[] cityID = new int[coord.GetLength(0)];
            bool[] cityVis = new bool[coord.GetLength(0)];

            double xx = 0;
            double yy = 0;
            double total = 0;
            double result = 0;


            double[] unsorted = new double[data.GetLength(1)];
            double[] sorted = new double[data.GetLength(1)];
            double[,] distances = new double[2, data.GetLength(1)];
                        
            //City knows it's coordinates and whether or not it's been visited
            for (int i = 0; i < data.GetLength(0); i++)
            {
                
                cityID[i] = i;
                CityX[i] = coord[i, 0];
                CityY[i] = coord[i, 1];
                cityVis[i] = false;
            }

            //Algorithm starts here
            for (int q = 0; q < cityID.Length; q++)
            {
                currentCity = cityID[q]; //save which city we started on
                sCity = currentCity;

                //Reinitialize control values
                total = 0;
                cnt = 0;
                k = 0;

                for (int i = 0; i < cityVis.Length; i++)
                {
                    cityVis[i] = false;
                }

                for (int i = 0; i < data.GetLength(1); i++)
                {
                    //Find out what the nearest city is from our starting point, and order them 
                    //from shortest to longest distance
                    distances[0, i] = Math.Sqrt(Math.Pow((cityX[currentCity] - CityX[i]), 2) +
                                                             Math.Pow((cityY[currentCity] - CityY[i]), 2));
                    distances[1, i] = data[currentCity, i];
                }

                
                    while (cnt < data.GetLength(0)) //while there are still cities left to visit
                    {
                        while (x < distances.GetLength(1)) //while we haven't compared to all the rest of the cities
                        {
                            if (distances[0, x] == distances[1, a]) //if our reference and closest match
                            {
                                if (cityVis[x] == false) //if the city hasn't been visited before
                                {
                                    cityVis[x] = true; //mark city as visited
                                    currentPath[k] = cityID[x];
                                    k++;
                                    cnt++;
                                    total += distances[1, a];

                                    xx = CityX[x];
                                    yy = CityY[x];

                                    //build new reference table
                                    distances = RefTable(CityX, CityY, xx, yy, data, cityID[x]);

                                    a = 0;
                                    x = 0;

                                    break;
                                }

                                else //if the city has been visited before
                                {
                                    a++;//move to next city
                                    x = 0;//start comparing from the first city again
                                }//end else
                            }//end if

                            else
                            {
                                x++;//compare with next city
                            }//end else

                        } //end inner while
                    }//end outer while
                //Add distance from last city to starting city
                total += Math.Sqrt(Math.Pow((xx - CityX[sCity]), 2) + Math.Pow((yy - CityY[sCity]), 2));

                currentPath[k] = cityID[sCity];

                //Check to see if it's the best path found
                if (result == 0)
                {
                    result = total;
                    for (int i = 0; i < currentPath.Length; i++ )
                        ShortestPath[i] = currentPath[i];
                }

                if (total < result)
                {
                    result = total;
                    for (int i = 0; i < currentPath.Length; i++)
                        ShortestPath[i] = currentPath[i];
                }

                    
               
            }//end for
            Formatted = result.ToString("N0");
            
        }//end method Greedy

        public double[,] RefTable(double[] cityX, double[] cityY, double xx, double yy, double[,] data, int currentCity)
        {
            double[,] distances = new double[2, data.GetLength(1)];

            for (int i = 0; i < cityX.Length; i++)
            {
                distances[0, i] = Math.Sqrt(Math.Pow((xx - cityX[i]), 2) +
                                                 Math.Pow((yy - cityY[i]), 2));
                distances[1, i] = data[currentCity, i];
            }

            return distances;
        }//end method RefTable

    }//end class Solver
}
